using System;
using System.Linq;
using System.Collections.Generic;

class Program
{
    struct Mast
    {
        public long x;
        public long h;
        public int id;
    }

    static void Main()
    {
        int n = int.Parse(Console.ReadLine());

        long[] xs = Console.ReadLine().Split().Select(long.Parse).ToArray();
        long[] hs = Console.ReadLine().Split().Select(long.Parse).ToArray();

        Mast[] a = new Mast[n];
        for (int i = 0; i < n; i++)
        {
            a[i].x = xs[i];
            a[i].h = hs[i];
            a[i].id = i;
        }

        Array.Sort(a, (p, q) => p.x.CompareTo(q.x));

        long[] ans = new long[n];
        for (int i = 0; i < n; i++) ans[i] = long.MaxValue;

        Stack<int> st = new Stack<int>();

        for (int i = 0; i < n; i++)
        {
            while (st.Count > 0 && a[st.Peek()].h < a[i].h)
                st.Pop();

            if (st.Count > 0)
            {
                long d = a[i].x - a[st.Peek()].x;
                ans[a[i].id] = Math.Min(ans[a[i].id], d);
            }

            st.Push(i);
        }

        st.Clear();

        for (int i = n - 1; i >= 0; i--)
        {
            while (st.Count > 0 && a[st.Peek()].h < a[i].h)
                st.Pop();

            if (st.Count > 0)
            {
                long d = a[st.Peek()].x - a[i].x;
                ans[a[i].id] = Math.Min(ans[a[i].id], d);
            }

            st.Push(i);
        }

        for (int i = 0; i < n; i++)
        {
            if (ans[i] == long.MaxValue)
                Console.WriteLine(-1);
            else
                Console.WriteLine(ans[i]);
        }
    }
}